    /*
     * Userspace program that communicates with the led_vga device driver
     * primarily through ioctls along with State machine for xbox controller
     *
     * Stephen A. Edwards
     * Columbia University

     * Created by : 
    	 Shikhar Kwatra (sk4094)
    	 Raghavendra Sirigeri (rs3603)
    	Last Modified: May 9, 2016 
     */

    #include <stdio.h>
    #include "vga_led.h"
    #include <sys/ioctl.h>
    #include <sys/types.h>
    #include <sys/stat.h>
    #include <fcntl.h>
    #include <string.h>
    #include <unistd.h>
    #include <fcntl.h>
    #include <stdlib.h>
    #include <pthread.h>
    #include "lodepng.h"
    #include "fileRead.h"
    #include <sys/time.h>
    #include<math.h>
    #include "fix16.h"


    #define RED_TWO_START 0x00000
    #define RED_ONE_START 0x02000
    #define RED_ZERO_START 0x04000
    #define GREEN_TWO_START 0x08000
    #define GREEN_ONE_START 0x06000
    #define GREEN_ZERO_START 0x0A000
    #define BLUE_TWO_START 0x0C000
    #define BLUE_ONE_START 0x0E000
    #define BLUE_ZERO_START 0x10000
      
    #define VGA_CONTROL_ADDR 0x22004
    #define SPRITE_RED_TWO_COL_ZERO 0x22100
    #define SPRITE_RED_TWO_COL_ONE 0x22101
    #define SPRITE_RED_TWO_COL_TWO 0x22102
    #define SPRITE_RED_TWO_COL_THREE 0x22103
    #define SPRITE_RED_ONE_COL_ZERO 0x22104
    #define SPRITE_RED_ONE_COL_ONE 0x22105
    #define SPRITE_RED_ONE_COL_TWO 0x22106
    #define SPRITE_RED_ONE_COL_THREE 0x22107
    #define SPRITE_RED_ZERO_COL_ZERO 0x22108
    #define SPRITE_RED_ZERO_COL_ONE 0x22109
    #define SPRITE_RED_ZERO_COL_TWO 0x2210A
    #define SPRITE_RED_ZERO_COL_THREE 0x2210B
    #define SPRITE_GREEN_TWO_COL_ZERO 0x2210C
    #define SPRITE_GREEN_TWO_COL_ONE 0x2210D
    #define SPRITE_GREEN_TWO_COL_TWO 0x2210E
    #define SPRITE_GREEN_TWO_COL_THREE 0x2210F
    #define SPRITE_GREEN_ONE_COL_ZERO 0x22110
    #define SPRITE_GREEN_ONE_COL_ONE 0x22111
    #define SPRITE_GREEN_ONE_COL_TWO 0x22112
    #define SPRITE_GREEN_ONE_COL_THREE 0x22113
    #define SPRITE_GREEN_ZERO_COL_ZERO 0x22114
    #define SPRITE_GREEN_ZERO_COL_ONE 0x22115
    #define SPRITE_GREEN_ZERO_COL_TWO 0x22116
    #define SPRITE_GREEN_ZERO_COL_THREE 0x22117
    #define SPRITE_BLUE_TWO_COL_ZERO 0x22118
    #define SPRITE_BLUE_TWO_COL_ONE 0x22119
    #define SPRITE_BLUE_TWO_COL_TWO 0x2211A
    #define SPRITE_BLUE_TWO_COL_THREE 0x2211B
    #define SPRITE_BLUE_ONE_COL_ZERO 0x2211C
    #define SPRITE_BLUE_ONE_COL_ONE 0x2211D
    #define SPRITE_BLUE_ONE_COL_TWO 0x2211E
    #define SPRITE_BLUE_ONE_COL_THREE 0x2211F
    #define SPRITE_BLUE_ZERO_COL_ZERO 0x22120
    #define SPRITE_BLUE_ZERO_COL_ONE 0x22121
    #define SPRITE_BLUE_ZERO_COL_TWO 0x22122
    #define SPRITE_BLUE_ZERO_COL_THREE 0x22123
    #define SPRITE_CONFIG_ADDR 0x22124
    #define SPRITE_ZERO_PIXEL_OFFSET_X_ADDR 0x22125
    #define SPRITE_ZERO_PIXEL_OFFSET_Y_ADDR 0x22126
    #define SPRITE_ZERO_TRANSLATED_ORIGIN_X_ADDR 0x22127
    #define SPRITE_ZERO_TRANSLATED_ORIGIN_Y_ADDR 0x22128
    #define SPRITE_ZERO_ROTATE_X_VEC_ADDR 0x22129
    #define SPRITE_ZERO_ROTATE_Y_VEC_ADDR 0x2212A
    #define SPRITE_ZERO_ATTRIBUTES_ADDR 0x2212B
    #define SOUND_CONTROL_ADDR 0x2212C

    #define NAME_TABLE_START 0x12000

    #define NAME_TABLE_ENTRIES 65537
    #define PATTERN_TABLE_ENTRIES 257
    

    int vga_led_fd,rx=640,ry=480, rxprev=64,ryprev=48,j,rxp=1,ryp=1,flagb,flaga,i=0,count=0,flagl,flagr,flagRB,kx = 1,ky = 1, state = 0;
    int blockLeftRight=0, pixelLeftRight = 0, lapTime =0, speedup = 0;
    char lposx,hposx,lposy,hposy,Aval,Bval,Xval,Yval,du_val,dd_val,dl_val,dr_val, RB_val, prevBval='1';
    //XBOX Controller reading from command line
    FILE *fp;
    int fd;
    int flags;
    char path[1035];
    static unsigned char message[8] = { 0xc8, 0xc8, 0x79, 0x79,
    				      0x66, 0x7F, 0x66, 0x3F };

    pthread_mutex_t mutex1 = PTHREAD_MUTEX_INITIALIZER;
    //Car 
    struct car{
    	int posx,posy;
    	int velx,vely;
    	int ax,ay;
    };
    struct car car1,car2;
    /* Read and print the segment values */
    void print_segment_info() {
      vga_led_arg_t vla;
      int i;

      for (i = 0 ; i < VGA_LED_DIGITS ; i++) {
        vla.digit = i;
        if (ioctl(vga_led_fd, VGA_LED_READ_DIGIT, &vla)) {
          perror("ioctl(VGA_LED_READ_DIGIT) failed");
          return;
        }
        //printf("%02x ", vla.segments);
      }
      //printf("\n");
    }



    /* Write the contents of the array to the display */
    void write_segments(const unsigned char segs[8])
    {
      vga_led_arg_t vla;
      int i;
      for (i = 0 ; i < VGA_LED_DIGITS ; i++) {
        vla.digit = i;
        vla.segments = segs[i];
        if (ioctl(vga_led_fd, VGA_LED_WRITE_DIGIT, &vla)) {
          perror("ioctl(VGA_LED_WRITE_DIGIT) failed");
          return;
        }
      }
    }

    void loadPatterns(int trackNum)
    {
       int i=0;
       int j=0;
       const char **mutatePatterns = getPatterns(trackNum);
       int *mutateNames    =  getNames(trackNum);  
       //printf("checkagain"); 
       for(i=0;i < PATTERN_TABLE_ENTRIES - 1; i++)
       {
        //printf("Loading pattern %d: name %s", i,	mutatePatterns[i]);
    	set32BitPattern(i, mutatePatterns[i]);
       }
       for(i=0;i< NAME_TABLE_ENTRIES- 1; i++)
       {	
    	writeCURegister(4*(NAME_TABLE_START + i), mutateNames[i]);
       }
       
       return;
    }

    void loadBlack()
    {
    	set32BitPattern(1, "grass.png");
    	for(j = 0 ;j<50;j++)
    	{	
    		for(i=294900;i<295042;i++)
    		{	
    		writeCURegister(i+ j*256,0x00000001);
    		}
    	}
    }

    void loadTrack()
    {
    	loadPatterns(2);
    	//track 
    }


    void write_segment_pat(unsigned int address, const unsigned int seg)
    {
      vga_led_arg_t vla;
      int i;
     {
        vla.digit = address;
        vla.segments = seg;
       	 if (ioctl(vga_led_fd, VGA_LED_WRITE_DIGIT, &vla)) {
       	   perror("ioctl(VGA_LED_WRITE_DIGIT) failed");
       	   return;
       	 }
       }
    }
    
    void writeCURegister(unsigned int address, const unsigned int data){
      vga_led_arg_t vla;
      int i;
      {
        vla.digit = address;
        vla.segments = data;
       	 if (ioctl(vga_led_fd, VGA_LED_WRITE_DIGIT, &vla)) {
       	   perror("ioctl(VGA_LED_WRITE_DIGIT) failed");
       	   return;
       	 }
       }
    }

    int openDriver()
    {
      static const char filename[] = "/dev/vga_led";
      printf("VGA LED Userspace program started\n");
      if ( (vga_led_fd = open(filename, O_RDWR)) == -1) {
        fprintf(stderr, "could not open %s\n", filename);
        return -1;
      }

    }

    void set128BitSprite(unsigned int spriteAddress , char* spriteName)
    {
        unsigned error0, error1, error2, error3;
        unsigned char *image0, *image1, *image2, *image3;
        unsigned width, height;
        char redPNGLineBuff[32];
        char greenPNGLineBuff[32];
        char bluePNGLineBuff[32];
        int x,y,pixelIndex,col, yOffset;
        
        char imageName0[50] = "";
        char imageName1[50] = "";
        char imageName2[50] = "";
        char imageName3[50] = "";
        char imageName4[50] = "";
        char imageName5[50] = "";
        char imageName6[50] = "";
        char imageName7[50] = "";
        char imageName8[50] = "";
        char imageName9[50] = "";
        char imageName10[50] = "";
        char imageName11[50] = "";
        char imageName12[50] = "";
        char imageName13[50] = "";
        char imageName14[50] = "";
        char imageName15[50] = "";
        
        strcat(imageName0, spriteName);
        strcat(imageName1, spriteName);
        strcat(imageName2, spriteName);
        strcat(imageName3, spriteName);
        strcat(imageName4, spriteName);
        strcat(imageName5, spriteName);
        strcat(imageName6, spriteName);
        strcat(imageName7, spriteName);
        strcat(imageName8, spriteName);
        strcat(imageName9, spriteName);
        strcat(imageName10, spriteName);
        strcat(imageName11, spriteName);
        strcat(imageName12, spriteName);
        strcat(imageName13, spriteName);
        strcat(imageName14, spriteName);
        strcat(imageName15, spriteName);
        
        strcat(imageName0, "-0-0.png");
        strcat(imageName1, "-1-0.png");
        strcat(imageName2, "-2-0.png");
        strcat(imageName3, "-3-0.png");
        strcat(imageName4, "-0-1.png");
        strcat(imageName5, "-1-1.png");
        strcat(imageName6, "-2-1.png");
        strcat(imageName7, "-3-1.png");
        strcat(imageName8, "-0-2.png");
        strcat(imageName9, "-1-2.png");
        strcat(imageName10, "-2-2.png");
        strcat(imageName11, "-3-2.png");
        strcat(imageName12, "-0-3.png");
        strcat(imageName13, "-1-3.png");
        strcat(imageName14, "-2-3.png");
        strcat(imageName15, "-3-3.png");

        unsigned int baseOffset;
        unsigned int redChanTwoData;
        unsigned int redChanOneData;
        unsigned int redChanZeroData;
        unsigned int greenChanTwoData;
        unsigned int greenChanOneData;
        unsigned int greenChanZeroData;
        unsigned int blueChanTwoData;
        unsigned int blueChanOneData;
        unsigned int blueChanZeroData;

        unsigned int redPixTwo;
        unsigned int redPixOne;
        unsigned int redPixZero;
        unsigned int greenPixTwo;
        unsigned int greenPixOne;
        unsigned int greenPixZero;
        unsigned int bluePixTwo;
        unsigned int bluePixOne;
        unsigned int bluePixZero;
        
       
        
       // printf("set128BitSprite is loading image: %s\n", imageName0);
       // printf("set128BitSprite is loading image: %s\n", imageName1);

    	for(y = 0; y < 128; y++){
    	    if(y == 0){
    		    error0 = lodepng_decode24_file(&image0, &width, &height, imageName0);
    			error1 = lodepng_decode24_file(&image1, &width, &height, imageName1);
    			error2 = lodepng_decode24_file(&image2, &width, &height, imageName2);
    			error3 = lodepng_decode24_file(&image3, &width, &height, imageName3);
    		    if(error0) printf("error %u: %s\n", error0, lodepng_error_text(error0));
    			if(error1) printf("error %u: %s\n", error1, lodepng_error_text(error1));
    			if(error2) printf("error %u: %s\n", error2, lodepng_error_text(error2));
    			if(error3) printf("error %u: %s\n", error3, lodepng_error_text(error3));
    			yOffset = 0;	
    		}
    		if(y == 32){
    		    error0 = lodepng_decode24_file(&image0, &width, &height, imageName4);
    			error1 = lodepng_decode24_file(&image1, &width, &height, imageName5);
    			error2 = lodepng_decode24_file(&image2, &width, &height, imageName6);
    			error3 = lodepng_decode24_file(&image3, &width, &height, imageName7);
    		    if(error0) printf("error %u: %s\n", error0, lodepng_error_text(error0));
    			if(error1) printf("error %u: %s\n", error1, lodepng_error_text(error1));
    			if(error2) printf("error %u: %s\n", error2, lodepng_error_text(error2));
    			if(error3) printf("error %u: %s\n", error3, lodepng_error_text(error3));
    			yOffset = 32;	
    		}
    		if(y == 64){
    		    error0 = lodepng_decode24_file(&image0, &width, &height, imageName8);
    			error1 = lodepng_decode24_file(&image1, &width, &height, imageName9);
    			error2 = lodepng_decode24_file(&image2, &width, &height, imageName10);
    			error3 = lodepng_decode24_file(&image3, &width, &height, imageName11);
    		    if(error0) printf("error %u: %s\n", error0, lodepng_error_text(error0));
    			if(error1) printf("error %u: %s\n", error1, lodepng_error_text(error1));
    			if(error2) printf("error %u: %s\n", error2, lodepng_error_text(error2));
    			if(error3) printf("error %u: %s\n", error3, lodepng_error_text(error3));	
    			yOffset = 64;
    		}
    		if(y == 96){
    		    error0 = lodepng_decode24_file(&image0, &width, &height, imageName12);
    			error1 = lodepng_decode24_file(&image1, &width, &height, imageName13);
    			error2 = lodepng_decode24_file(&image2, &width, &height, imageName14);
    			error3 = lodepng_decode24_file(&image3, &width, &height, imageName15);
    		    if(error0) printf("error %u: %s\n", error0, lodepng_error_text(error0));
    			if(error1) printf("error %u: %s\n", error1, lodepng_error_text(error1));
    			if(error2) printf("error %u: %s\n", error2, lodepng_error_text(error2));
    			if(error3) printf("error %u: %s\n", error3, lodepng_error_text(error3));	
    			yOffset = 96;
    		}
    		// Note, this is to flip the bit ordering due to the System verilog little endian format 
    		for(col=0;col <= 3;col++){	
    			for(x = 31; x >= 0; x--){
    				if(col==0){
                        redPNGLineBuff[x]   = image0[96*(y - yOffset) + x*3] / 32;        // Scale data to 3 bits
                        greenPNGLineBuff[x] = image0[96*(y - yOffset) + x*3 + 1] / 32;
                        bluePNGLineBuff[x]  = image0[96*(y - yOffset) + x*3 + 2] / 32;
    				}else if(col == 1){
                        redPNGLineBuff[x]   = image2[96*(y - yOffset) + x*3] / 32;        // Scale data to 3 bits
                        greenPNGLineBuff[x] = image2[96*(y - yOffset) + x*3 + 1] / 32;
                        bluePNGLineBuff[x]  = image2[96*(y - yOffset) + x*3 + 2] / 32;
    				}else if(col == 2){
    				    redPNGLineBuff[x]   = image1[96*(y - yOffset) + x*3] / 32;        // Scale data to 3 bits
    					greenPNGLineBuff[x] = image1[96*(y - yOffset) + x*3 + 1] / 32;
    					bluePNGLineBuff[x]  = image1[96*(y - yOffset) + x*3 + 2] / 32;    // Should be 1
    				}else {
    				    redPNGLineBuff[x]   = image3[96*(y - yOffset) + x*3] / 32;        // Scale data to 3 bits
                        greenPNGLineBuff[x] = image3[96*(y - yOffset) + x*3 + 1] / 32;
                        bluePNGLineBuff[x]  = image3[96*(y - yOffset) + x*3 + 2] / 32;    // Should be 3
    				}	    
    			}

                redChanTwoData = 0;
                redChanOneData = 0;
                redChanZeroData = 0;
                greenChanTwoData = 0;
                greenChanOneData = 0;
                greenChanZeroData = 0;
                blueChanTwoData = 0;
                blueChanOneData = 0;
                blueChanZeroData = 0;

    		    for(pixelIndex = 0; pixelIndex < 32; pixelIndex++){
                    // Extract 9 bits of compressed color 
                    redPixTwo    = (redPNGLineBuff[pixelIndex] & 0x04) != 0 ? 1 : 0;
                    redPixOne    = (redPNGLineBuff[pixelIndex] & 0x02) != 0 ? 1 : 0;
                    redPixZero   = (redPNGLineBuff[pixelIndex] & 0x01) != 0 ? 1 : 0;
                    greenPixTwo  = (greenPNGLineBuff[pixelIndex] & 0x04) != 0 ? 1 : 0;
                    greenPixOne  = (greenPNGLineBuff[pixelIndex] & 0x02) != 0 ? 1 : 0;
                    greenPixZero = (greenPNGLineBuff[pixelIndex] & 0x01) != 0 ? 1 : 0;
                    bluePixTwo   = (bluePNGLineBuff[pixelIndex] & 0x04) != 0 ? 1 : 0;
                    bluePixOne   = (bluePNGLineBuff[pixelIndex] & 0x02) != 0 ? 1 : 0;
                    bluePixZero  = (bluePNGLineBuff[pixelIndex] & 0x01) != 0 ? 1 : 0;

                    // Red 3 bit color channel
                    redChanTwoData = redChanTwoData + (redPixTwo << (pixelIndex));
                    redChanOneData = redChanOneData + (redPixOne << (pixelIndex));
                    redChanZeroData = redChanZeroData + (redPixZero << (pixelIndex));
                    // Green 3 bit color channel
                    greenChanTwoData = greenChanTwoData + (greenPixTwo << (pixelIndex));
                    greenChanOneData = greenChanOneData + (greenPixOne << (pixelIndex));
                    greenChanZeroData = greenChanZeroData + (greenPixZero << (pixelIndex));
                    // Blue 3 bit color channel
                    blueChanTwoData = blueChanTwoData + (bluePixTwo << (pixelIndex));
                    blueChanOneData = blueChanOneData + (bluePixOne << (pixelIndex));
                    blueChanZeroData = blueChanZeroData + (bluePixZero << (pixelIndex));
                }
    		      // Write color channels to fpga
    			if(col == 0){
    			      //printf("Red Channels\n");
    			      writeCURegister(4*(SPRITE_RED_TWO_COL_ZERO), redChanTwoData);
    			      writeCURegister(4*(SPRITE_RED_ONE_COL_ZERO), redChanOneData);
    			      writeCURegister(4*(SPRITE_RED_ZERO_COL_ZERO), redChanZeroData);
    			      //printf("Green Channels\n");
    			      writeCURegister(4*(SPRITE_GREEN_TWO_COL_ZERO), greenChanTwoData);
    			      writeCURegister(4*(SPRITE_GREEN_ONE_COL_ZERO), greenChanOneData);
    			      writeCURegister(4*(SPRITE_GREEN_ZERO_COL_ZERO), greenChanZeroData);
    			      //printf("Blue Channels\n");
    			      writeCURegister(4*(SPRITE_BLUE_TWO_COL_ZERO), blueChanTwoData);
    			      writeCURegister(4*(SPRITE_BLUE_ONE_COL_ZERO), blueChanOneData);
    			      writeCURegister(4*(SPRITE_BLUE_ZERO_COL_ZERO), blueChanZeroData);
    			}else if(col == 1){
    			     //printf("Red Channels\n");
    			      writeCURegister(4*(SPRITE_RED_TWO_COL_ONE), redChanTwoData);
    			      writeCURegister(4*(SPRITE_RED_ONE_COL_ONE), redChanOneData);
    			      writeCURegister(4*(SPRITE_RED_ZERO_COL_ONE), redChanZeroData);
    			      //printf("Green Channels\n");
    			      writeCURegister(4*(SPRITE_GREEN_TWO_COL_ONE), greenChanTwoData);
    			      writeCURegister(4*(SPRITE_GREEN_ONE_COL_ONE), greenChanOneData);
    			      writeCURegister(4*(SPRITE_GREEN_ZERO_COL_ONE), greenChanZeroData);
    			      //printf("Blue Channels\n");
    			      writeCURegister(4*(SPRITE_BLUE_TWO_COL_ONE), blueChanTwoData);
    			      writeCURegister(4*(SPRITE_BLUE_ONE_COL_ONE), blueChanOneData);
    			      writeCURegister(4*(SPRITE_BLUE_ZERO_COL_ONE), blueChanZeroData); 
    			}else if(col == 2){
    			      //printf("Red Channels\n");
    			      writeCURegister(4*(SPRITE_RED_TWO_COL_TWO), redChanTwoData);
    			      writeCURegister(4*(SPRITE_RED_ONE_COL_TWO), redChanOneData);
    			      writeCURegister(4*(SPRITE_RED_ZERO_COL_TWO), redChanZeroData);
    			      //printf("Green Channels\n");
    			      writeCURegister(4*(SPRITE_GREEN_TWO_COL_TWO), greenChanTwoData);
    			      writeCURegister(4*(SPRITE_GREEN_ONE_COL_TWO), greenChanOneData);
    			      writeCURegister(4*(SPRITE_GREEN_ZERO_COL_TWO), greenChanZeroData);
    			      //printf("Blue Channels\n");
    			      writeCURegister(4*(SPRITE_BLUE_TWO_COL_TWO), blueChanTwoData);
    			      writeCURegister(4*(SPRITE_BLUE_ONE_COL_TWO), blueChanOneData);
    			      writeCURegister(4*(SPRITE_BLUE_ZERO_COL_TWO), blueChanZeroData);
    			}else {
    				//printf("Red Channels\n");
    			      writeCURegister(4*(SPRITE_RED_TWO_COL_THREE), redChanTwoData);
    			      writeCURegister(4*(SPRITE_RED_ONE_COL_THREE), redChanOneData);
    			      writeCURegister(4*(SPRITE_RED_ZERO_COL_THREE), redChanZeroData);
    			      //printf("Green Channels\n");
    			      writeCURegister(4*(SPRITE_GREEN_TWO_COL_THREE), greenChanTwoData);
    			      writeCURegister(4*(SPRITE_GREEN_ONE_COL_THREE), greenChanOneData);
    			      writeCURegister(4*(SPRITE_GREEN_ZERO_COL_THREE), greenChanZeroData);
    			      //printf("Blue Channels\n");
    			      writeCURegister(4*(SPRITE_BLUE_TWO_COL_THREE), blueChanTwoData);
    			      writeCURegister(4*(SPRITE_BLUE_ONE_COL_THREE), blueChanOneData);
    			      writeCURegister(4*(SPRITE_BLUE_ZERO_COL_THREE), blueChanZeroData);
    			}      
            }	
            	
            writeCURegister(4*(SPRITE_CONFIG_ADDR), y); 

    	  	if(y == 31){
    			free(image0);
    		  	free(image1);
    		  	free(image2);
    		  	free(image3);   
    		}
    		if(y==63){
    			free(image0);
    		  	free(image1);
    		  	free(image2);
    		  	free(image3);   
    		}
    		if(y==95){
    			free(image0);
    		  	free(image1);
    		  	free(image2);
    		  	free(image3);   
    		}
    		if(y==127){
    			free(image0);
    			free(image1);
    		  	free(image2);
    		  	free(image3);   
    		}   
    	}
    }


    void set32BitPattern(unsigned int patternIndex , const char* filename)
    {
      unsigned error;
      unsigned char* image;
      unsigned width, height;
      char redPNGLineBuff[32];
      char greenPNGLineBuff[32];
      char bluePNGLineBuff[32];
      int x,y,pixelIndex;

      unsigned int baseOffset;
      unsigned int redChanTwoData;
      unsigned int redChanOneData;
      unsigned int redChanZeroData;
      unsigned int greenChanTwoData;
      unsigned int greenChanOneData;
      unsigned int greenChanZeroData;
      unsigned int blueChanTwoData;
      unsigned int blueChanOneData;
      unsigned int blueChanZeroData;

      unsigned int redPixTwo;
      unsigned int redPixOne;
      unsigned int redPixZero;
      unsigned int greenPixTwo;
      unsigned int greenPixOne;
      unsigned int greenPixZero;
      unsigned int bluePixTwo;
      unsigned int bluePixOne;
      unsigned int bluePixZero;

      baseOffset = patternIndex * 32;

      error = lodepng_decode24_file(&image, &width, &height, filename);
      if(error) printf("error %u: %s\n", error, lodepng_error_text(error));

      for(y = 0; y < 32; y++){
        for(x = 0; x < 32; x++){
          redPNGLineBuff[x]   = image[96*y + x*3] / 32;        // Scale data to 3 bits
          greenPNGLineBuff[x] = image[96*y + x*3 + 1] / 32;
          bluePNGLineBuff[x]  = image[96*y + x*3 + 2] / 32;
        }

        redChanTwoData = 0;
        redChanOneData = 0;
        redChanZeroData = 0;
        greenChanTwoData = 0;
        greenChanOneData = 0;
        greenChanZeroData = 0;
        blueChanTwoData = 0;
        blueChanOneData = 0;
        blueChanZeroData = 0;

        for(pixelIndex = 0; pixelIndex < 32; pixelIndex++){
          // Extract 9 bits of compressed color 
          redPixTwo    = (redPNGLineBuff[pixelIndex] & 0x04) != 0 ? 1 : 0;
          redPixOne    = (redPNGLineBuff[pixelIndex] & 0x02) != 0 ? 1 : 0;
          redPixZero   = (redPNGLineBuff[pixelIndex] & 0x01) != 0 ? 1 : 0;
          greenPixTwo  = (greenPNGLineBuff[pixelIndex] & 0x04) != 0 ? 1 : 0;
          greenPixOne  = (greenPNGLineBuff[pixelIndex] & 0x02) != 0 ? 1 : 0;
          greenPixZero = (greenPNGLineBuff[pixelIndex] & 0x01) != 0 ? 1 : 0;
          bluePixTwo   = (bluePNGLineBuff[pixelIndex] & 0x04) != 0 ? 1 : 0;
          bluePixOne   = (bluePNGLineBuff[pixelIndex] & 0x02) != 0 ? 1 : 0;
          bluePixZero  = (bluePNGLineBuff[pixelIndex] & 0x01) != 0 ? 1 : 0;

          // Red 3 bit color channel
          redChanTwoData = redChanTwoData + (redPixTwo << (pixelIndex));
          redChanOneData = redChanOneData + (redPixOne << (pixelIndex));
          redChanZeroData = redChanZeroData + (redPixZero << (pixelIndex));
          // Green 3 bit color channel
          greenChanTwoData = greenChanTwoData + (greenPixTwo << (pixelIndex));
          greenChanOneData = greenChanOneData + (greenPixOne << (pixelIndex));
          greenChanZeroData = greenChanZeroData + (greenPixZero << (pixelIndex));
          // Blue 3 bit color channel
          blueChanTwoData = blueChanTwoData + (bluePixTwo << (pixelIndex));
          blueChanOneData = blueChanOneData + (bluePixOne << (pixelIndex));
          blueChanZeroData = blueChanZeroData + (bluePixZero << (pixelIndex));

          // Write color channels to fpga

          //printf("*****************Line number: %d *******************\n", y);
          //printf("Red Channels\n");
          writeCURegister(4*(RED_TWO_START  + baseOffset + y), redChanTwoData);
          writeCURegister(4*(RED_ONE_START  + baseOffset + y), redChanOneData);
          writeCURegister(4*(RED_ZERO_START + baseOffset + y), redChanZeroData);
          //printf("Green Channels\n");
          writeCURegister(4*(GREEN_TWO_START  + baseOffset + y), greenChanTwoData);
          writeCURegister(4*(GREEN_ONE_START  + baseOffset + y), greenChanOneData);
          writeCURegister(4*(GREEN_ZERO_START + baseOffset + y), greenChanZeroData);
          //printf("Blue Channels\n");
          writeCURegister(4*(BLUE_TWO_START + baseOffset + y), blueChanTwoData);
          writeCURegister(4*(BLUE_ONE_START  + baseOffset + y), blueChanOneData);
          writeCURegister(4*(BLUE_ZERO_START + baseOffset + y), blueChanZeroData);
        }
      }
        
      free(image);   
    }

    int float2fix(double f)
    {
        int q16,ahalf,q8;	
        q16 =  fix16_from_dbl(f);
        ahalf = q16 >= 0 ? (1<<7) : -(1<<7);
        q8 = (q16+ahalf) / (1<<8);
        //printf("\n%d",q8);
        return q8;
    }

    void map()
    {
        printf("%s", path);
        char *source = path;
        char *destA = strstr(source, "A:");
        char *destB = strstr(source, "B:");
        char *destX = strstr(source, "X:");
        char *destY = strstr(source, "Y:");
        char *dest_du = strstr(source, "du:");
        char *dest_dd = strstr(source, "dd:");
        char *dest_dl = strstr(source, "dl:");
        char *dest_dr = strstr(source, "dr:");
        char *dest_RB = strstr(source, "RB:");
        int posA, posB, posX, posY, pos_du, pos_dl, pos_dd, pos_dr,pos_RB;
        posA = destA - source;
        posB = destB - source;
        posY = destY - source;
        posX = destX - source;
        pos_du = dest_du - source;
        pos_dl = dest_dl - source;
        pos_dd = dest_dd - source;
        pos_dr = dest_dr - source;
        pos_RB = dest_RB - source;
        Aval = path[posA+2];
        Bval = path[posB+2];
        Yval = path[posY+2];
        Xval = path[posX+2];
        du_val = path[pos_du+3];
        dd_val = path[pos_dd+3];
        dr_val = path[pos_dr+3];
        dl_val = path[pos_dl+3];
        RB_val = path[pos_RB+3];

        //printf("\n%d with value: %c",posA, path[posA+2]);
        //printf("\n%d with value: %c",posB, path[posB+2]);
        //printf("\n%d with value: %c",posY, path[posY+2]);
        //printf("\n%d with value: %c",posX, path[posX+2]); 
        //printf("\n%d with value: %c",pos_du, path[pos_du+3]);
        //printf("\n%d with value: %c",pos_dd, path[pos_dd+3]);
        //printf("\n%d with value: %c",pos_dr, path[pos_dr+3]);
        //printf("\n%d with value: %c\n",pos_dl, path[pos_dl+3]);
        //printf("\n%d with value: %c\n",pos_RB, path[pos_RB+3]);

        lposx = car1.posx & 0xFF;
        hposx = (car1.posx>>8) & 0x03;
        lposy = car1.posy & 0xFF;
        hposy = (car1.posy>>8) & 0x03;
        message[0] = hposx;
        message[1] = lposx;
        message[2] = hposy;
        message[3] = lposy;
    }

    int g = 0;

    void *myThreadFun(void *vargp)
    {

      fp = popen("./xboxdrv --quiet --no-uinput", "r");
      if (fp == NULL) {
        printf("Failed to run command\n" );
        exit(1);
      }
    while(1){
      if(fgets(path, sizeof(path)-1, fp) != NULL) {
        pthread_mutex_lock(&mutex1);
        map();
        pthread_mutex_unlock(&mutex1);
        i = 0;
        flaga = Aval=='1'?1:0;
        flagb = Bval =='1'?1:0;
        flagl = dl_val =='1'?1:0;
        flagr = dr_val == '1'?1:0;
        flagRB = RB_val == '1'?1:0;
        //printf("flaga %d\n",flaga);
        //printf("%d\n",count++);
        }
    }
      pclose(fp);
      printf("VGA LED Userspace program terminating\n");

    }

    void *myThreadFun1(void *vargp)
    {   int i,k=0,t=0,a=0,m=0,pixelup,blockup,stateMenu=0,state=0,stateAval=0,leftroad,rightroad, statecarselect=0,stateCarSel=0,statesprite=0,stateScores=0;
        int *names;
        char **patterns;
        char car[100]="";
        int sizex = 64;
        int sizey = 64;
        double theta;
        double rotationOriginX;
        double rotationOriginY;
        double vecXNormalized;
        double vecYNormalized; 
        double translatedXOrigin,translatedYOrigin;
        
        
        struct timeval tv;
        static const char filename[] = "/dev/vga_led";
        printf("VGA LED Userspace program started\n");
        if ( (vga_led_fd = open(filename, O_RDWR)) == -1) {
        fprintf(stderr, "could not open %s\n", filename);
        return -1;
        }

    
    //stateMenu
    // 0->New Game
    // 1-> Scores
    // 2-> Quit
    
        // Initialize the origin for the menu
    	writeCURegister(4*VGA_CONTROL_ADDR,0);
    	loadPatterns(1);
    	writeCURegister(4*VGA_CONTROL_ADDR,1);
    	printf("\n%s",car);
    	writeCURegister(557056,0);
    	writeCURegister(557060,0);
    	writeCURegister(SPRITE_ZERO_ATTRIBUTES_ADDR*4,0);   // Sprite 0 invisible 
        strcpy(car,"./CarSprites/YellowCar/yellow");
    	//set128BitSprite(0, car);
    	writeCURegister(SOUND_CONTROL_ADDR*4,0);   //Disable Sound	
    
     while(1)
    {
    ///////////////////////////MENU SCREEN STATE MACHINE//////////////////////////////
    	if(dd_val=='1' && stateMenu == 0 && state ==0)
    	{
    		stateMenu=1;
    		printf("goingtostate1");
    		writeCURegister(557060,24);
    		usleep(300000);
    	}
    	else if(dd_val=='1' && stateMenu == 1 && state ==0)
    	{
    		stateMenu=2;
    		writeCURegister(557060,48);
    		usleep(300000);
    	}
    	else if(dd_val=='1' && stateMenu == 2 && state ==0)
    	{
    		stateMenu=2;
    		writeCURegister(557060,48);
    		usleep(300000);
    	}
    	else{ //do nothing;
    	}

    	if(du_val=='1' && stateMenu == 0 && state ==0)
    	{
    		stateMenu=0;
    		writeCURegister(557060,0);
    		usleep(300000);
    	}
    	else if(du_val=='1' && stateMenu == 1 && state ==0)
    	{
    		stateMenu=0;
    		writeCURegister(557060,0);
    		usleep(300000);
    	}
    	else if(du_val=='1' && stateMenu == 2 && state ==0)
    	{
    		stateMenu=1;
    		writeCURegister(557060,24);
    		usleep(300000);
    	}
    	else
    	{ //do nothing;
    	}
    ////////////////////////////////////////////////////////////////////////////////

    //////////////////////NEW GAME PRESSED!! GO TO CAR SELECTION MENU//////////////////////
    

    	if(stateMenu == 0 && Aval=='1' && state==0)  // New Game Pressed => Load the Car Selection Menu
    	{   
    		state = 2;
    	}
        
        if(stateMenu == 1 && Aval=='1' && state==0)
        {
        writeCURegister(557060,0);
        writeCURegister(4*VGA_CONTROL_ADDR,0);
    	loadPatterns(6);
    	writeCURegister(4*VGA_CONTROL_ADDR,1);
        stateScores = 1;
        }
        
        if(stateScores==1 && Bval=='1')
        {
        writeCURegister(4*VGA_CONTROL_ADDR,0);
    	loadPatterns(1);
    	writeCURegister(4*VGA_CONTROL_ADDR,1);
        stateScores = 0;
        stateMenu = 0;
        }
        
        
/////////////////////////////////CAR DECELERATION//////////////////////////////////////// 
   	if(Aval=='0' && state==1 && !(dl_val=='1') && !(dr_val=='1') && stateAval==1) 
    	{   
    	    //writeCURegister(558244,1); //Making the SPRITE visible 
    		pixelup--;
    		writeCURegister(557068,pixelup);
    		if(abs(pixelup)%31==0)
    		{
    		pixelup = 0;
    		blockup--;		
    		}
    		if(blockup==0)
    		{blockup = 255;}
    		usleep(8000-speedup);	
    		writeCURegister(557060,1023 + blockup);		
    		lapTime++;
    		if(Aval=='0' && lapTime%100==0)  // Deceleration for the car 
    		speedup=speedup - 500;
    		if(speedup<=0)
    		{speedup = 0;
    		 stateAval = 0;
    		} 
    	} 	
 
////////////////////////////////CAR DECELERATION STATE ENDS/////////////////////////////// 
 
 
//////////////////////////////////////////CAR SELECTION MENU//////////////////////////////
        if(state ==2)
        {
            if(statecarselect==0)
            {   
                writeCURegister(4*VGA_CONTROL_ADDR,0);
                loadPatterns(4);
                writeCURegister(4 * VGA_CONTROL_ADDR,1);
                writeCURegister(557056,2);
                statecarselect = 1;
            }
             
        	if(dr_val=='1' && stateCarSel == 0)
        	{
        		stateCarSel=1;
        		printf("goingtostate1");
        		writeCURegister(557060,24);
        		strcpy(car,"./CarSprites/RedCar/RedRaceCar");
        		usleep(300000);
        		
        	}
        	else if(dr_val=='1' && stateCarSel == 1)
        	{
        		stateCarSel=2;
        		writeCURegister(557060,48);
        		strcpy(car,"./CarSprites/BlueCar/slice");
        		usleep(300000);
        	}
        	else if(dr_val=='1' && stateCarSel == 2)
        	{
        		stateCarSel=2;
        		writeCURegister(557060,48);
        		strcpy(car,"./CarSprites/BlueCar/slice");
        		usleep(300000);
        	}
        	else{ //do nothing;
        	}

        	if(dl_val=='1' && stateCarSel == 0)
        	{
        		stateCarSel=0;
        		writeCURegister(557060,0);
        	    strcpy(car,"./CarSprites/YellowCar/yellow");
        		usleep(300000);
        	}
        	else if(dl_val=='1' && stateCarSel == 1)
        	{
        		stateCarSel=0;
        		writeCURegister(557060,0);
        		strcpy(car,"./CarSprites/YellowCar/yellow");
        		usleep(300000);
        	}
        	else if(dl_val=='1' && stateCarSel == 2)
        	{
        		stateCarSel=1;
        		writeCURegister(557060,24);
        		strcpy(car,"./CarSprites/RedCar/RedRaceCar");
        		usleep(300000);
        	}
        	else
        	{ //do nothing;
        	}
        }
                if(Aval=='1' && state ==2 && statesprite==0)
                {
                state=1;
                printf("\n%s\n",car);
                writeCURegister(4*VGA_CONTROL_ADDR,0);
                set128BitSprite(0, car);
                statesprite = 1;        
                loadTrack();
                writeCURegister(4*VGA_CONTROL_ADDR,1);  
                gettimeofday(&tv, NULL);
                printf("Seconds since Jan. 1, 1970: %ld\n", tv.tv_sec);
                writeCURegister(557056,16);
    	        writeCURegister(557060,1023);
                writeCURegister(558228,500); // Sprite 0 X location
        		writeCURegister(558232,600); // Sprite 0 Y location	
                writeCURegister(SPRITE_ZERO_ATTRIBUTES_ADDR*4,1); //Car Sprite Visibility}
                writeCURegister(SOUND_CONTROL_ADDR*4,2); //Set Sound 
                }



////////////////////////////////////TRACK HAS BEEN LOADED//////////////////////////////////////////
            if(dr_val=='1' && state ==1 && !(Aval=='1')) // Left key pressed in Track screen => Steer left
        	{		
        		/*pixelLeftRight++;		
        		writeCURegister(557064,pixelLeftRight);
        		if(pixelLeftRight%31==0)
        		{
        			blockLeftRight++; 
        			pixelLeftRight=0;
        		}
        		if(blockLeftRight==255)
        		{
        		blockLeftRight=0;
        		}
        		usleep(8000-speedup);
        		writeCURegister(557056,16 + blockLeftRight);*/
        		//do nothing
        	}

            if(dl_val=='1' && state ==1 && !(Aval=='1')) // Right key pressed in Track screen => Steer Right
        	{	
        		/*pixelLeftRight--;
        		writeCURegister(557064,pixelLeftRight);
        		if(abs(pixelLeftRight)%31==0)
        		{	
        			blockLeftRight--; 
        			pixelLeftRight=0;
        		}
        		if(blockLeftRight==0)
        		{
        		blockLeftRight=255;
        		}
        		usleep(8000-speedup);
        		writeCURegister(557056, 16 + blockLeftRight);*/
        		//do nothing
        	}
        
/////////////////////////////////////////RIGHT KEY WITH ACCELERATION STATE///////////////////////////////////////////////

            if(Aval=='1' && state ==1 && dr_val=='1') //Right key pressed with Acceleration => Steer Right diagonally
            {
                    theta += 0.01;
                    if(theta == 0.5)
                    theta = 0.5;
                    usleep(500);
                    rotationOriginX = -64*cos(theta) - 64*sin(theta);
                    rotationOriginY = -64*sin(theta) + 64*cos(theta);

                    translatedXOrigin = rotationOriginX + 64;
                    translatedYOrigin = -rotationOriginY + 64;

                    vecXNormalized = 2*cos(theta);
                    vecYNormalized = 2*sin(theta);
                    
                    writeCURegister(4*SPRITE_ZERO_TRANSLATED_ORIGIN_X_ADDR,float2fix(translatedXOrigin));
                    writeCURegister(4*SPRITE_ZERO_TRANSLATED_ORIGIN_Y_ADDR,float2fix(translatedYOrigin));
                    writeCURegister(4*SPRITE_ZERO_ROTATE_X_VEC_ADDR,float2fix(vecXNormalized));
                    writeCURegister(4*SPRITE_ZERO_ROTATE_Y_VEC_ADDR,float2fix(vecYNormalized));
                pixelup--;
                pixelLeftRight++;
                usleep(100+100*cos(theta));		
        		writeCURegister(557064,pixelLeftRight);
        		usleep(50+100*sin(theta));
        		writeCURegister(557068,pixelup);
        		if(abs(pixelup)%31==0)
        		{
        		pixelup = 0;
        		blockup--;		
        		}
        		if(blockup==0)
        		{blockup = 255;}
        		if(abs(pixelLeftRight)%31==0)
        		{
        			blockLeftRight++; 
        			pixelLeftRight=0;
        		}
        		if(blockLeftRight==255)
        		{
        		blockLeftRight=0;
        		}			
        		usleep(8000-speedup);
        		writeCURegister(557060,1023 + blockup);
        		writeCURegister(557056,16 + blockLeftRight);
        		lapTime++;
    		
        		//straight path bounds
        		if(Aval=='1' && dr_val=='1' && ((!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=239 && blockup<=255) || (!(blockLeftRight >=11 && blockLeftRight <15) && blockup>=212 && blockup<=229) || (!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=144 && blockup<=200) || (!(blockLeftRight >=11 && blockLeftRight <16) && blockup>=116 && blockup<=133) || (!(blockLeftRight >=0 && blockLeftRight <=5) && blockup>=48 && blockup<=105) || (!(blockLeftRight >=11 && blockLeftRight <16) && blockup>=21 && blockup<=36) || (!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=0 && blockup<=9)))
        		{
        		    speedup =-500;
        		}  
        		
        		//1st right diagonal path bounds
        		if(blockup==240)
        		{
        		    leftroad = 0;
        		    rightroad = 5;
        		}
        		if(blockup>=229 && blockup<=240)
        		{
        		    leftroad = 0 + 240-blockup;
        		    rightroad = 5 + 240-blockup;
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
        		
        		//1st left diagonal path bounds
        		if(blockup==213)
        		{
        		    leftroad = 11;
        		    rightroad = 15;
        		}
        		if(blockup>=201 && blockup<=213)
        		{
        		    leftroad = 11 - (213-blockup);
        		    rightroad = 15 - (213-blockup); 
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
        		
        		//2nd right diagonal path bounds
        		if(blockup==144)
        		{
        		    leftroad = 0;
        		    rightroad = 5;
        		}
        		if(blockup>=133 && blockup<=144)
        		{
        		    leftroad = 0 + 144-blockup;
        		    rightroad = 5 + 144-blockup;
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
        	    		
        		
        		//2nd left diagonal path bounds
        		
        		if(blockup==117)
        		{
        		    leftroad = 11;
        		    rightroad = 15;
        		}
        		if(blockup>=105 && blockup<=117)
        		{
        		    leftroad = 11 - (117-blockup);
        		    rightroad = 15 - (117-blockup);
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
        		
        		//3rd right diagonal path bounds
        		if(blockup==49)
        		{
        		    leftroad = 0;
        		    rightroad = 5;
        		}
        		if(blockup>=38 && blockup<=49)
        		{
        		    leftroad = 0 + 49-blockup;
        		    rightroad = 5 + 49-blockup; 
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
        		
        		
        		//3rd left diagonal path bounds
        		if(blockup==20)
        		{
        		    leftroad = 11;
        		    rightroad = 15;
        		}
        		if(blockup>=9 && blockup<=20)
        		{
        		    leftroad = 11 - (20-blockup);
        		    rightroad = 15 - (20-blockup); 
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
        		
            }
//////////////////////////////////////RIGHT KEY WITH ACCELERATION ENDS/////////////////////////////

//////////////////////////////////////////////LEFT KEY WITH ACCELERATION STATE//////////////////////
            if(Aval=='1' && state ==1 && dl_val=='1')
            {
                    theta -= 0.01;
                    //if(theta == -0.25)
                    //theta = -0.25;
                    usleep(500);
                    rotationOriginX = -64*cos(theta) - 64*sin(theta);
                    rotationOriginY = -64*sin(theta) + 64*cos(theta);

                    translatedXOrigin = rotationOriginX + 64;
                    translatedYOrigin = -rotationOriginY + 64;

                    vecXNormalized = 2*cos(theta);
                    vecYNormalized = 2*sin(theta);
                    
                    writeCURegister(4*SPRITE_ZERO_TRANSLATED_ORIGIN_X_ADDR,float2fix(translatedXOrigin));
                    writeCURegister(4*SPRITE_ZERO_TRANSLATED_ORIGIN_Y_ADDR,float2fix(translatedYOrigin));
                    writeCURegister(4*SPRITE_ZERO_ROTATE_X_VEC_ADDR,float2fix(vecXNormalized));
                    writeCURegister(4*SPRITE_ZERO_ROTATE_Y_VEC_ADDR,float2fix(vecYNormalized));
                    pixelup--;
                    //pixelup = pixelup 
                    
                    pixelLeftRight--;	
                    usleep(100+100*cos(theta));	
            		writeCURegister(557064,pixelLeftRight);
            		usleep(50+100*sin(theta));
            		writeCURegister(557068,pixelup);
            		//usleep(1000);
            		if(abs(pixelup)%31==0)
            		{
            		pixelup = 0;
            		blockup--;		
            		}
            		if(blockup==0)
            		{blockup = 255;}
            		if(abs(pixelLeftRight)%31==0)
            		{
            			blockLeftRight--; 
            			pixelLeftRight=0;
            		}
            		if(blockLeftRight==0)
            		{
            		blockLeftRight=255;
            		}			
            		usleep(8000-speedup);
            		writeCURegister(557060,1023 + blockup);
            		usleep(1000);
            		writeCURegister(557056,16 + blockLeftRight);
            		usleep(1000);
            		lapTime++; 
            		//straight path bounds 
            		if(Aval=='1' && dl_val=='1' && ((!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=239 && blockup<=255) || (!(blockLeftRight >=11 && blockLeftRight <15) && blockup>=212 && blockup<=229) || (!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=144 && blockup<=200) || (!(blockLeftRight >=11 && blockLeftRight <16) && blockup>=116 && blockup<=133) || (!(blockLeftRight >=0 && blockLeftRight <=5) && blockup>=48 && blockup<=105) || (!(blockLeftRight >=11 && blockLeftRight <16) && blockup>=21 && blockup<=36) || (!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=0 && blockup<=9)))
            		speedup =-500;
                		
            		//1st right diagonal path bounds
            		if(blockup==240)
            		{
            		    leftroad = 0;
            		    rightroad = 5;
            		}
            		if(blockup>=229 && blockup<=240)
            		{
            		    leftroad = 0 + 240-blockup;
            		    rightroad = 5 + 240-blockup; 
            		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
            		    {
            		        speedup=-500;
            		    }
            		}
            		
            		//1st left diagonal path bounds
            		
            		if(blockup==213)
            		{
            		    leftroad = 11;
            		    rightroad = 15;
            		}
            		if(blockup>=201 && blockup<=213)
            		{
            		    leftroad = 11 - (213-blockup);
            		    rightroad = 15 - (213-blockup); 
            		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
            		    {
            		        speedup=-500;
            		    }
            		}
            		
            	    //2nd right diagonal path bounds
            		if(blockup==144)
            		{
            		    leftroad = 0;
            		    rightroad = 5;
            		}
            		if(blockup>=133 && blockup<=144)
            		{
            		    leftroad = 0 + 144-blockup;
            		    rightroad = 5 + 144-blockup;
            		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
            		    {
            		        speedup=-500;
            		    }
            		}
            		
            	    //2nd left diagonal path bounds
            		if(blockup==117)
            		{
            		    leftroad = 11;
            		    rightroad = 15;
            		}
            		if(blockup>=105 && blockup<=117)
            		{
            		    leftroad = 11 - (117-blockup);
            		    rightroad = 15 - (117-blockup);
            		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
            		    {
            		        speedup=-500;
            		    }
            		}
            		
            		//3rd right diagonal path bounds
            		if(blockup==49)
            		{
            		    leftroad = 0;
            		    rightroad = 5;
            		}
            		if(blockup>=38 && blockup<=49)
            		{
            		    leftroad = 0 + 49-blockup;
            		    rightroad = 5 + 49-blockup;
            		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
            		    {
            		        speedup=-500;
            		    }
            		}
            		
            		//3rd left diagonal path bounds
            		if(blockup==20)
            		{
            		    leftroad = 11;
            		    rightroad = 15;
            		}
            		if(blockup>=9 && blockup<=20)
            		{
            		    leftroad = 11 - (20-blockup);
            		    rightroad = 15 - (20-blockup);
            		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
            		    {
            		        speedup=-500;
            		    }
            		}
            }     
            
//////////////////////////////////END : LEFT KEY STATE WITH ACCELERATION//////////////////////////////////


///////////////////////////////////START: STRAIGHT ACCELERATION/////////////////////////////////////////////       
            if(Aval=='1' && state==1 && !(dl_val=='1') && !(dr_val=='1')) // New game has been pressed, On track screen => Start the Engine!
            {         
        	    stateAval = 1; 
        	    writeCURegister(SPRITE_ZERO_ATTRIBUTES_ADDR*4,1); //Making the SPRITE visible 
                if(theta<=0.01)
                {
                                usleep(1000);
                    rotationOriginX = -64*cos(theta) - 64*sin(theta);
                    rotationOriginY = -64*sin(theta) + 64*cos(theta);

                    translatedXOrigin = rotationOriginX + 64;
                    translatedYOrigin = -rotationOriginY + 64;

                    vecXNormalized = 2*cos(theta);
                    vecYNormalized = 2*sin(theta);
                    
                    writeCURegister(4*SPRITE_ZERO_TRANSLATED_ORIGIN_X_ADDR,float2fix(translatedXOrigin));
                    writeCURegister(4*SPRITE_ZERO_TRANSLATED_ORIGIN_Y_ADDR,float2fix(translatedYOrigin));
                    writeCURegister(4*SPRITE_ZERO_ROTATE_X_VEC_ADDR,float2fix(vecXNormalized));
                    writeCURegister(4*SPRITE_ZERO_ROTATE_Y_VEC_ADDR,float2fix(vecYNormalized));
                    theta=theta+0.05;
                }
                if(theta>=0.01)
                {
                                usleep(1000);
                    rotationOriginX = -64*cos(theta) - 64*sin(theta);
                    rotationOriginY = -64*sin(theta) + 64*cos(theta);

                    translatedXOrigin = rotationOriginX + 64;
                    translatedYOrigin = -rotationOriginY + 64;

                    vecXNormalized = 2*cos(theta);
                    vecYNormalized = 2*sin(theta);
                    
                    writeCURegister(4*SPRITE_ZERO_TRANSLATED_ORIGIN_X_ADDR,float2fix(translatedXOrigin));
                    writeCURegister(4*SPRITE_ZERO_TRANSLATED_ORIGIN_Y_ADDR,float2fix(translatedYOrigin));
                    writeCURegister(4*SPRITE_ZERO_ROTATE_X_VEC_ADDR,float2fix(vecXNormalized));
                    writeCURegister(4*SPRITE_ZERO_ROTATE_Y_VEC_ADDR,float2fix(vecYNormalized));
                    theta=theta-0.05;
                }
        		pixelup--;

        		writeCURegister(557068,pixelup);
        		if(abs(pixelup)%31==0)
        		{
        		pixelup = 0;
        		blockup--;		
        		}		
        		if(blockup==0)
        		{blockup = 255;}
        		usleep(8000-speedup);	
            		writeCURegister(557060,1023 + blockup);
            		usleep(1000);
            		writeCURegister(557056,16 + blockLeftRight);	
        		lapTime++;
        		if(Aval=='1' && lapTime%200==0)
        		speedup=speedup + 500;
        		if(speedup>=6000)
        		speedup = 6000;
        		if(Aval=='1' && ((!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=239 && blockup<=255) || (!(blockLeftRight >=11 && blockLeftRight <15) && blockup>=212 && blockup<=229) || (!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=144 && blockup<=200) || (!(blockLeftRight >=11 && blockLeftRight <16) && blockup>=116 && blockup<=133) || (!(blockLeftRight >=0 && blockLeftRight <=5) && blockup>=48 && blockup<=105) || (!(blockLeftRight >=11 && blockLeftRight <16) && blockup>=21 && blockup<=36) || (!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=0 && blockup<=9)))
        		speedup =-500;
        	//	printf("\nLAPTIME: %d\n",lapTime); 
        	
    	//1st right diagonal path bounds
    		if(blockup==240)
    		{
    		    leftroad = 0;
    		    rightroad = 5;
    		}
    		if(blockup>=229 && blockup<=240)
    		{
    		    leftroad = 0 + 240-blockup;
    		    rightroad = 5 + 240-blockup; 
    		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
    		    {
    		        speedup=-500;
    		    }
    		}
    		
    		//1st left diagonal path bounds	
    		if(blockup==213)
    		{
    		    leftroad = 11;
    		    rightroad = 15;
    		}
    		if(blockup>=201 && blockup<=213)
    		{
    		    leftroad = 11 - (213-blockup);
    		    rightroad = 15 - (213-blockup);
    		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
    		    {
    		        speedup=-500;
    		    }
    		}
    		
    	    //2nd right diagonal path bounds
    		if(blockup==144)
    		{
    		    leftroad = 0;
    		    rightroad = 5;
    		}
    		if(blockup>=133 && blockup<=144)
    		{
    		    leftroad = 0 + 144-blockup;
    		    rightroad = 5 + 144-blockup; 
    		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
    		    {
    		        speedup=-500;
    		    }
    		}
    		
    		
    	    //2nd left diagonal path bounds	
    		if(blockup==117)
    		{
    		    leftroad = 11;
    		    rightroad = 15;
    		}
    		if(blockup>=105 && blockup<=117)
    		{
    		    leftroad = 11 - (117-blockup);
    		    rightroad = 15 - (117-blockup);
    		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
    		    {
    		        speedup=-500;
    		    }
    		}
    		
    		//3rd right diagonal path bounds
    		if(blockup==49)
    		{
    		    leftroad = 0;
    		    rightroad = 5;
    		}
    		if(blockup>=38 && blockup<=49)
    		{
    		    leftroad = 0 + 49-blockup;
    		    rightroad = 5 + 49-blockup; 
    		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
    		    {
    		        speedup=-500;
    		    }
    		}
    		
    		
    		//3rd left diagonal path bounds
    		if(blockup==20)
    		{
    		    leftroad = 11;
    		    rightroad = 15;
    		}
    		if(blockup>=9 && blockup<=20)
    		{
    		    leftroad = 11 - (20-blockup);
    		    rightroad = 15 - (20-blockup);
    		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
    		    {
    		        speedup=-500;
    		    }
    		}
}
    	
 

///////////////////////////////////////////START OF "BRAKE" STATE//////////////////////////////////// 
    	if(Bval=='1' && state ==1) // Break (Deceleration) pressed, On track screen => Stop the Engine, Move back!
    	{	
    		pixelup++;
    		writeCURegister(557068,pixelup);
    		if(abs(pixelup)%31==0)
    		{
    		pixelup = 0;
    		blockup++;		
    		}
    		if(blockup==255)
    		{blockup = 0;}
    		usleep(10000);	
    		writeCURegister(557060, 1023 + blockup);
    	}

///////////////////////////////////END OF BRAKE STATE/////////////////////////////////////////////

//////////////////////////////TURBO MODE STATE : STRAIGHT INITIATION//////////////////////////////
    	if(RB_val =='1' && state ==1 && !(du_val=='1' && !dr_val=='1')) // Boost mode => Speed up!! 
    	{
    		pixelup--;
    		writeCURegister(557068,pixelup);
    		if(abs(pixelup)%31==0)
    		{
    		pixelup = 0;
    		blockup--;		
    		}
    		if(blockup==0)
    		{blockup = 255;}
    		usleep(2000);	
    		writeCURegister(557060,1023 + blockup);
    		lapTime+= 3;	 
        	if(RB_val=='1' && ((!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=239 && blockup<=255) || (!(blockLeftRight >=11 && blockLeftRight <15) && blockup>=212 && blockup<=229) || (!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=144 && blockup<=200) || (!(blockLeftRight >=11 && blockLeftRight <16) && blockup>=116 && blockup<=133) || (!(blockLeftRight >=0 && blockLeftRight <=5) && blockup>=48 && blockup<=105) || (!(blockLeftRight >=11 && blockLeftRight <16) && blockup>=21 && blockup<=36) || (!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=0 && blockup<=9)))
            		speedup =-500;
            //printf("\nLAPTIME: %d\n",lapTime); 
            	
        	//1st right diagonal path bounds
        		if(blockup==240)
        		{
        		    leftroad = 0;
        		    rightroad = 5;
        		}
    		    if(blockup>=229 && blockup<=240)
    		    {
    		        leftroad = 0 + 240-blockup;
    		        rightroad = 5 + 240-blockup; 
    		        if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
    		        {
    		        speedup=-500;
    		        }
    		    }
    		
    		    //1st left diagonal path bounds	
    		    if(blockup==213)
    		    {
    		        leftroad = 11;
    		        rightroad = 15;
    		    }
        		if(blockup>=201 && blockup<=213)
        		{
        		    leftroad = 11 - (213-blockup);
        		    rightroad = 15 - (213-blockup);
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
    		
    	        //2nd right diagonal path bounds
        		if(blockup==144)
        		{
        		    leftroad = 0;
        		    rightroad = 5;
        		}
        		if(blockup>=133 && blockup<=144)
        		{
        		    leftroad = 0 + 144-blockup;
        		    rightroad = 5 + 144-blockup; 
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
    		
    		
        	    //2nd left diagonal path bounds	
        		if(blockup==117)
        		{
        		    leftroad = 11;
        		    rightroad = 15;
        		}
        		if(blockup>=105 && blockup<=117)
        		{
        		    leftroad = 11 - (117-blockup);
        		    rightroad = 15 - (117-blockup);
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
        		
        		//3rd right diagonal path bounds
        		if(blockup==49)
        		{
        		    leftroad = 0;
        		    rightroad = 5;
        		}
        		if(blockup>=38 && blockup<=49)
        		{
        		    leftroad = 0 + 49-blockup;
        		    rightroad = 5 + 49-blockup; 
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
        		
        		
        		//3rd left diagonal path bounds
        		if(blockup==20)
        		{
        		    leftroad = 11;
        		    rightroad = 15;
        		}
        		if(blockup>=9 && blockup<=20)
        		{
        		    leftroad = 11 - (20-blockup);
        		    rightroad = 15 - (20-blockup);
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}   
    	}
////////////////////////////TURBO MODE: STRAIGHT INITIATION STATE ENDS///////////////////
     	
////////////////////////////////TURBO MODE: STRAIGHT WITH RIGHT//////////////////////////
        if(RB_val =='1' && state ==1 && dr_val=='1') // Boost mode 
    	{
    		pixelup--;
    		writeCURegister(557068,pixelup);
    		if(abs(pixelup)%31==0)
    		{
    		    pixelup = 0;
    		    blockup--;		
    		}
    		if(blockup==0)
    		{blockup = 255;}
    		usleep(2000);	
    		writeCURegister(557060,1023 + blockup);
    		lapTime+= 3;	 
        	if(RB_val=='1' && dr_val=='1' && ((!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=239 && blockup<=255) || (!(blockLeftRight >=11 && blockLeftRight <15) && blockup>=212 && blockup<=229) || (!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=144 && blockup<=200) || (!(blockLeftRight >=11 && blockLeftRight <16) && blockup>=116 && blockup<=133) || (!(blockLeftRight >=0 && blockLeftRight <=5) && blockup>=48 && blockup<=105) || (!(blockLeftRight >=11 && blockLeftRight <16) && blockup>=21 && blockup<=36) || (!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=0 && blockup<=9)))
            		speedup =-500;
            //printf("\nLAPTIME: %d\n",lapTime); 
            	
        	//1st right diagonal path bounds
        		if(blockup==240)
        		{
        		    leftroad = 0;
        		    rightroad = 5;
        		}
    		    if(blockup>=229 && blockup<=240)
    		    {
    		        leftroad = 0 + 240-blockup;
    		        rightroad = 5 + 240-blockup; 
    		        if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
    		        {
    		        speedup=-500;
    		        }
    		    }
    		
    		    //1st left diagonal path bounds	
    		    if(blockup==213)
    		    {
    		        leftroad = 11;
    		        rightroad = 15;
    		    }
        		if(blockup>=201 && blockup<=213)
        		{
        		    leftroad = 11 - (213-blockup);
        		    rightroad = 15 - (213-blockup);
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
    		
    	        //2nd right diagonal path bounds
        		if(blockup==144)
        		{
        		    leftroad = 0;
        		    rightroad = 5;
        		}
        		if(blockup>=133 && blockup<=144)
        		{
        		    leftroad = 0 + 144-blockup;
        		    rightroad = 5 + 144-blockup; 
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
    		
    		
        	    //2nd left diagonal path bounds	
        		if(blockup==117)
        		{
        		    leftroad = 11;
        		    rightroad = 15;
        		}
        		if(blockup>=105 && blockup<=117)
        		{
        		    leftroad = 11 - (117-blockup);
        		    rightroad = 15 - (117-blockup);
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
        		
        		//3rd right diagonal path bounds
        		if(blockup==49)
        		{
        		    leftroad = 0;
        		    rightroad = 5;
        		}
        		if(blockup>=38 && blockup<=49)
        		{
        		    leftroad = 0 + 49-blockup;
        		    rightroad = 5 + 49-blockup; 
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
        		
        		
        		//3rd left diagonal path bounds
        		if(blockup==20)
        		{
        		    leftroad = 11;
        		    rightroad = 15;
        		}
        		if(blockup>=9 && blockup<=20)
        		{
        		    leftroad = 11 - (20-blockup);
        		    rightroad = 15 - (20-blockup);
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}   
    	}

/////////////////////////////////TURBO MODE: STRAIGHT WITH RIGHT ENDS//////////////////////

//////////////////////////////////TURBO MODE: STRAIGHT WITH LEFT///////////////////////////

           if(RB_val =='1' && state ==1 && dl_val=='1' && !(dr_val=='1')) // Boost mode => Speed up!! 
    	{
    		pixelup--;
    		writeCURegister(557068,pixelup);
    		if(abs(pixelup)%31==0)
    		{
    		    pixelup = 0;
    		    blockup--;		
    		}
    		if(blockup==0)
    		{blockup = 255;}
    		usleep(2000);	
    		writeCURegister(557060,1023 + blockup);
    		lapTime+= 3;	 
        	if(RB_val=='1' && dl_val=='1' && ((!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=239 && blockup<=255) || (!(blockLeftRight >=11 && blockLeftRight <15) && blockup>=212 && blockup<=229) || (!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=144 && blockup<=200) || (!(blockLeftRight >=11 && blockLeftRight <16) && blockup>=116 && blockup<=133) || (!(blockLeftRight >=0 && blockLeftRight <=5) && blockup>=48 && blockup<=105) || (!(blockLeftRight >=11 && blockLeftRight <16) && blockup>=21 && blockup<=36) || (!(blockLeftRight >=0 && blockLeftRight <5) && blockup>=0 && blockup<=9)))
            		speedup =-500;
            //printf("\nLAPTIME: %d\n",lapTime); 
            	
        	//1st right diagonal path bounds
        		if(blockup==240)
        		{
        		    leftroad = 0;
        		    rightroad = 5;
        		}
    		    if(blockup>=229 && blockup<=240)
    		    {
    		        leftroad = 0 + 240-blockup;
    		        rightroad = 5 + 240-blockup; 
    		        if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
    		        {
    		        speedup=-500;
    		        }
    		    }
    		
    		    //1st left diagonal path bounds	
    		    if(blockup==213)
    		    {
    		        leftroad = 11;
    		        rightroad = 15;
    		    }
        		if(blockup>=201 && blockup<=213)
        		{
        		    leftroad = 11 - (213-blockup);
        		    rightroad = 15 - (213-blockup);
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
    		
    	        //2nd right diagonal path bounds
        		if(blockup==144)
        		{
        		    leftroad = 0;
        		    rightroad = 5;
        		}
        		if(blockup>=133 && blockup<=144)
        		{
        		    leftroad = 0 + 144-blockup;
        		    rightroad = 5 + 144-blockup; 
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
    		
    		
        	    //2nd left diagonal path bounds	
        		if(blockup==117)
        		{
        		    leftroad = 11;
        		    rightroad = 15;
        		}
        		if(blockup>=105 && blockup<=117)
        		{
        		    leftroad = 11 - (117-blockup);
        		    rightroad = 15 - (117-blockup);
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
        		
        		//3rd right diagonal path bounds
        		if(blockup==49)
        		{
        		    leftroad = 0;
        		    rightroad = 5;
        		}
        		if(blockup>=38 && blockup<=49)
        		{
        		    leftroad = 0 + 49-blockup;
        		    rightroad = 5 + 49-blockup; 
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}
        		
        		
        		//3rd left diagonal path bounds
        		if(blockup==20)
        		{
        		    leftroad = 11;
        		    rightroad = 15;
        		}
        		if(blockup>=9 && blockup<=20)
        		{
        		    leftroad = 11 - (20-blockup);
        		    rightroad = 15 - (20-blockup);
        		    if(!(blockLeftRight>=leftroad && blockLeftRight<=rightroad))
        		    {
        		        speedup=-500;
        		    }
        		}   
    	}
//////////////////////////////////////TURBO MODE: STEER LEFT WITH TURBO ENDS/////////////
        	
//////////////////////////////////////END OF TURBO MODE STATE////////////////////////////    	
    		
    		
 ///////////////////////////////////END OF TRACK STATE//////////////////////////////////////////
    	/*if(lapTime >=40000 && state ==1) // End of Lap:1 
    	{
    		state = 2;
    		lapTime =0;
    		//STOP
    		//END of Track 1 Screen 
    	}*/
/////////////////////////////////////////////////////////////////////////////////////////////


    
////////////////////////////////////ROTATION CONDITION ADDED////////////////////////////////
   
    if(Xval=='1')
    {
        theta -= 0.01;
        usleep(50000);
        rotationOriginX = -64*cos(theta) - 64*sin(theta);
        rotationOriginY = -64*sin(theta) + 64*cos(theta);

        translatedXOrigin = rotationOriginX + 64;
        translatedYOrigin = -rotationOriginY + 64;

        vecXNormalized = 2*cos(theta);
        vecYNormalized = 2*sin(theta);
        
        writeCURegister(4*SPRITE_ZERO_TRANSLATED_ORIGIN_X_ADDR,float2fix(translatedXOrigin));
        writeCURegister(4*SPRITE_ZERO_TRANSLATED_ORIGIN_Y_ADDR,float2fix(translatedYOrigin));
        writeCURegister(4*SPRITE_ZERO_ROTATE_X_VEC_ADDR,float2fix(vecXNormalized));
        writeCURegister(4*SPRITE_ZERO_ROTATE_Y_VEC_ADDR,float2fix(vecYNormalized));
       
        /*writeCURegister(4*SPRITE_ZERO_TRANSLATED_ORIGIN_X_ADDR,0);
        writeCURegister(4*SPRITE_ZERO_TRANSLATED_ORIGIN_Y_ADDR,0);
        writeCURegister(4*SPRITE_ZERO_ROTATE_X_VEC_ADDR,512);
        writeCURegister(4*SPRITE_ZERO_ROTATE_Y_VEC_ADDR,0);
         */
    }
    
////////////////////////////////////////ROTATION STATE ENDS////////////////////////////////////
    
    }
    }

    int main()
    {
      pthread_t tid,tid1;
      //openDriver();
    	
      


      pthread_create(&tid, NULL, myThreadFun, (void *)i);
      pthread_create(&tid1, NULL, myThreadFun1, (void *)i);
      //pthread_exit(NULL);
      pthread_join(tid,NULL);
      pthread_join(tid1,NULL);
      return 0;
    }
